import { camelCase } from 'lodash';
import React from 'react';
import { connect } from 'react-redux';
import { getScreenElement } from '../../service/screen-base-definition';
import { executeCallbackInScreenContext, triggerFieldEvent } from '../../utils/events';
import { getFieldTitle } from './carbon-helpers';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
function FieldActions(props) {
    const { screenId, fieldActionsMap, isDisabled, additionalFieldActions } = props;
    if (fieldActionsMap?.length || additionalFieldActions?.length) {
        return (React.createElement(React.Fragment, null,
            additionalFieldActions?.map(fieldAction => {
                const onClick = () => executeCallbackInScreenContext(fieldAction.onClick, screenId);
                return (React.createElement(ButtonMinor, { key: fieldAction.id, buttonType: "tertiary", iconType: fieldAction.icon, iconTooltipMessage: fieldAction.title, "aria-label": fieldAction.title, disabled: isDisabled, "data-testid": `e-header-action-${fieldAction.id} e-header-action-bind-${camelCase(fieldAction.id)} e-header-action-label-${camelCase(fieldAction.title)}`, onClick: onClick }));
            }),
            fieldActionsMap
                ?.filter(fieldAction => fieldAction.icon && !fieldAction.isHidden)
                .map(fieldAction => {
                const onClick = () => {
                    triggerFieldEvent(screenId, fieldAction.id, 'onClick');
                };
                const title = getFieldTitle(screenId, fieldAction, null);
                return (React.createElement(ButtonMinor, { key: fieldAction.id, buttonType: "tertiary", iconType: fieldAction.icon, iconTooltipMessage: title, "aria-label": title, disabled: isDisabled || fieldAction.isDisabled || fieldAction.isHidden, "data-testid": `e-header-action-${fieldAction.id} e-header-action-bind-${camelCase(fieldAction.id)} e-header-action-label-${camelCase(title)}`, onClick: onClick }));
            })));
    }
    return null;
}
const mapStateToProps = (state, props) => {
    const screenDefinition = state.screenDefinitions[props.screenId];
    const fieldProperties = screenDefinition.metadata.uiComponentProperties[props.fieldId];
    const screenElement = getScreenElement(screenDefinition);
    const fieldActionsMap = typeof fieldProperties?.fieldActions === 'function' ? fieldProperties?.fieldActions.apply(screenElement) : [];
    return { ...props, fieldActionsMap };
};
export default connect(mapStateToProps)(FieldActions);
//# sourceMappingURL=field-actions-component.js.map