import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { DynamicPodControlObject } from './dynamic-pod-control-object';
class DynamicPodDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = DynamicPodControlObject;
    }
}
/**
 * Initializes the decorated member as a [DynamicPodDecorator]{@link DynamicPodDecoratorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DynamicPodDecorator]{@link DynamicPodDecoratorControlObject} field will be initialized with.
 */
export function dynamicPodField(properties) {
    return standardDecoratorImplementation(properties, DynamicPodDecorator, FieldKey.DynamicPod);
}
export function dynamicPodFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=dynamic-pod-decorator.js.map