import { addDisabledToProperties, addOptionTypeToProperties } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { DropdownListControlObject } from './dropdown-list-control-object';
class DropdownListDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = DropdownListControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addOptionTypeToProperties({ propertyDetails, dataType, properties });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [DropdownList]{@link DropdownListControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DropdownList]{@link DropdownListControlObject} field will be initialized with.
 */
export function dropdownListField(properties) {
    return standardDecoratorImplementation(properties, DropdownListDecorator, FieldKey.DropdownList);
}
export function dropdownListFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=dropdown-list-decorator.js.map