import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { DropdownListDecoratorProperties, DropdownListExtensionDecoratorProperties } from './dropdown-list-types';
/**
 * Initializes the decorated member as a [DropdownList]{@link DropdownListControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DropdownList]{@link DropdownListControlObject} field will be initialized with.
 */
export declare function dropdownListField<T extends ScreenExtension<T>>(properties: DropdownListDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function dropdownListFieldOverride<T extends ScreenExtension<T>>(properties: DropdownListExtensionDecoratorProperties<T>): (target: T, name: string) => void;
//# sourceMappingURL=dropdown-list-decorator.d.ts.map