import React from 'react';
export const DropdownListCellRenderer = React.memo(props => {
    const { api, fieldProperties, localizedOptions, node: { rowIndex }, tableElementId, } = props;
    const getTestId = () => {
        const columnIndex = (api.getColumns() ?? []).indexOf(props.column) + 1;
        return `${tableElementId}-${rowIndex}-${columnIndex}`;
    };
    if (props.data && props.colDef.field) {
        return (React.createElement(fieldProperties.wrapper, { ...props },
            React.createElement("div", { style: { display: 'flex', alignItems: 'center' } },
                React.createElement("span", { "data-testid": getTestId() }, localizedOptions?.[props.value] ?? props.value))));
    }
    return null;
});
DropdownListCellRenderer.displayName = 'DropdownListCellRenderer';
//# sourceMappingURL=dropdown-list-cell-renderer.js.map