/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { DetailListControlObject } from './detail-list-control-object';
class DetailListDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = DetailListControlObject;
    }
}
/**
 * Initializes the decorated member as a [Detail List]{@link DetailListControlObject} field with the provided properties
 *
 * @param properties The properties that the [Detail List]{@link DetailListControlObject} field will be initialized with
 */
export function detailListField(properties) {
    return standardDecoratorImplementation(properties, DetailListDecorator, FieldKey.DetailList);
}
export function detailListFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=detail-list-decorator.js.map