/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { DetailListDecoratorProperties, DetailListExtensionDecoratorProperties } from './detail-list-types';
/**
 * Initializes the decorated member as a [Detail List]{@link DetailListControlObject} field with the provided properties
 *
 * @param properties The properties that the [Detail List]{@link DetailListControlObject} field will be initialized with
 */
export declare function detailListField<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any>(properties: DetailListDecoratorProperties<Extend<CT>, ReferencedItemType>): (target: CT, name: string) => void;
export declare function detailListFieldOverride<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any>(properties: DetailListExtensionDecoratorProperties<CT, ReferencedItemType>): (target: CT, name: string) => void;
//# sourceMappingURL=detail-list-decorator.d.ts.map