import type { CalendarDate } from '@internationalized/date';
import type { Datetime } from '@sage/xtrem-date-time';
import type { LocalizeLocale } from '@sage/xtrem-shared';
import type { CurrentDatesState, DatetimeRangeValue } from './datetime-range-types';
export interface DatetimeRangeComponentState {
    value: CurrentDatesState;
    endDate: CalendarDate | null;
    validationError: boolean;
    endTime: string | null;
    startDate: CalendarDate | null;
    startTime: string | null;
    timeZone: string;
    isDirty: boolean;
    openInputPopover: 'start' | 'end' | null;
}
export type Action = {
    type: 'SET_START_DATE';
    date: DatetimeRangeComponentState['startDate'];
} | {
    type: 'SET_END_DATE';
    date: DatetimeRangeComponentState['endDate'];
} | {
    type: 'SET_START_TIME';
    time: DatetimeRangeComponentState['startTime'];
} | {
    type: 'SET_END_TIME';
    time: DatetimeRangeComponentState['endTime'];
} | {
    type: 'SET_OPEN_POPOVER_ON_INPUT';
    inputName: 'start' | 'end';
    isOpen: boolean;
} | {
    type: 'RESET';
    value?: DatetimeRangeValue | null;
    timeZone: string;
};
export interface UseDatetimeRangeProps {
    value?: DatetimeRangeValue | null;
    fieldProperties: any;
    locale: LocalizeLocale;
    setFieldValue: any;
    validate: any;
    elementId: string;
    screenId: string;
    onChange: (value: DatetimeRangeValue | null) => void;
}
export interface UseDatetimeRangeResult {
    currentDates: CurrentDatesState;
    endDate: CalendarDate | null;
    validationError: boolean;
    endTime: string | null;
    handleEndDateChange: (date: CalendarDate) => void;
    handleEndTimeChange: (time: string) => void;
    handlePopoverOpenChange: (isOpen: boolean, inputName: 'start' | 'end') => void;
    handleStartDateChange: (date: CalendarDate) => void;
    handleStartTimeChange: (time: string) => void;
    isDirty: boolean;
    maxDateValue: Datetime;
    minDateValue: Datetime;
    openInputPopover: 'start' | 'end' | null;
    startDate: CalendarDate | null;
    startTime: string | null;
    timeZone: string;
}
export declare function useDatetimeRange({ fieldProperties, locale, value }: UseDatetimeRangeProps): UseDatetimeRangeResult;
//# sourceMappingURL=use-datetime-range.d.ts.map