import { CalendarDate } from '@internationalized/date';
import { Datetime, formatDateToCurrentLocale, formatTimeToLocale, isValidIsoDate, } from '@sage/xtrem-date-time';
export function calendarDateToDatetime(calendarDate, timeZone) {
    const { year, month, day } = calendarDate;
    return Datetime.make(year, month, day, 0, 0, 0, 0, timeZone);
}
export function datetimeToCalendarDate(datetime, timeZone) {
    const valueWithTz = datetime.inTimeZone(timeZone);
    return new CalendarDate(valueWithTz.year, valueWithTz.month, valueWithTz.day);
}
export function datetimeToTime(datetime, timeZone) {
    const valueWithTz = datetime.inTimeZone(timeZone);
    return valueWithTz.time.toString();
}
export function toDatetime(input, timeZone, locale = 'base') {
    if (Datetime.isDatetime(input)) {
        return input.inTimeZone(timeZone);
    }
    if (input instanceof Date) {
        return Datetime.fromJsDate(input, timeZone);
    }
    if (typeof input === 'string' && isValidIsoDate(input)) {
        return Datetime.parse(input, locale, undefined, timeZone);
    }
    throw new Error('Invalid date parameter');
}
export const formatDatetime = (date, locale = 'base') => {
    if (!date)
        return '';
    const formattedDate = formatDateToCurrentLocale(date, locale, 'FullDate');
    return `${formattedDate} - ${formatTimeToLocale(date.time, locale)}`;
};
export const isDateInRange = (date, startDate, endDate) => {
    return date.compare(startDate) >= 0 && date.compare(endDate) <= 0;
};
export function isValidTimeZone(timeZone) {
    try {
        Intl.DateTimeFormat(undefined, { timeZone });
        return true;
    }
    catch (e) {
        return false;
    }
}
export const makeDatetime = (date, time, timeZone = 'UTC') => {
    return Datetime.make(date.year, date.month, date.day, time.hour, time.minute, time.second, undefined, timeZone);
};
//# sourceMappingURL=datetime-range-utils.js.map