import { CalendarDate } from '@internationalized/date';
import { Datetime, type Time } from '@sage/xtrem-date-time';
import { type LocalizeLocale } from '@sage/xtrem-shared';
export declare function calendarDateToDatetime(calendarDate: CalendarDate, timeZone?: string): Datetime;
export declare function datetimeToCalendarDate(datetime: Datetime, timeZone: string): CalendarDate;
export declare function datetimeToTime(datetime: Datetime, timeZone: string): string;
export declare function toDatetime(input: Datetime | Date | string, timeZone: string, locale?: LocalizeLocale): Datetime;
export declare const formatDatetime: (date: Datetime | null | undefined, locale?: LocalizeLocale) => string;
export declare const isDateInRange: (date: Datetime, startDate: Datetime, endDate: Datetime) => boolean;
export declare function isValidTimeZone(timeZone: string): boolean;
export declare const makeDatetime: (date: CalendarDate, time: Time, timeZone?: string) => Datetime;
//# sourceMappingURL=datetime-range-utils.d.ts.map