/// <reference types="react" />
import type { CalendarDate } from '@internationalized/date';
import type { ClientNode } from '@sage/xtrem-client';
import type { Datetime } from '@sage/xtrem-date-time';
import type { LocalizeLocale } from '@sage/xtrem-shared';
import type { Extend } from '../../../service/page-extension';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { BlockControlObject } from '../../control-objects';
import type { EditableFieldProperties } from '../../editable-field-control-object';
import type { FieldControlObjectInstance } from '../../types';
import type { BaseEditableComponentProperties } from '../field-base-component-types';
import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedValidatable, Sizable, Validatable } from '../traits';
export interface DatetimeRangeProperties<CT extends ScreenExtension<CT> = ScreenBase, NodeType = any> extends EditableFieldProperties<CT, NodeType>, Sizable {
    isTimeZoneHidden?: boolean;
    timeZone?: string;
    minDate?: Date;
    maxDate?: Date;
    defaultDate?: Date | Datetime | string;
}
export interface DatetimeRangeDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<DatetimeRangeProperties<CT, ReferencedItemType>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, Sizable, Validatable<CT, string> {
}
export interface NestedDatetimeRangeProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<DatetimeRangeProperties<CT, ContextNodeType>, 'bind'>, NestedChangeable<CT>, Nested<ContextNodeType>, Sizable, NestedValidatable<CT, string, ContextNodeType> {
}
export type DatetimeRangeExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> = ChangeableOverrideDecoratorProperties<DatetimeRangeDecoratorProperties<Extend<CT>, ReferencedItemType>, CT>;
export interface CurrentDatesState {
    start: Datetime | null;
    end: Datetime | null;
}
export interface DatetimeRangeValue extends Required<Pick<CurrentDatesState, 'start' | 'end'>> {
}
export interface DatetimeRangeComponentProps<T extends ClientNode = any> extends BaseEditableComponentProperties<DatetimeRangeDecoratorProperties<any, T>, DatetimeRangeValue> {
}
export interface DatetimeComponentProps {
    'aria-label': string;
    screenId: string;
    elementId: string;
    date: CalendarDate | null;
    fieldId: string;
    inputRef?: React.RefObject<HTMLInputElement>;
    isDisabled?: boolean;
    isPopoverOpen: boolean;
    isReadOnly?: boolean;
    isTimeZoneHidden?: boolean;
    locale: LocalizeLocale;
    maxDate?: Datetime;
    minDate?: Datetime;
    onDateChange: (date: CalendarDate | null) => void;
    onPopperOpenChange: (isOpen: boolean, inputName: 'start' | 'end') => void;
    onTimeChange: (string: string | null) => void;
    rangeStartDate: CalendarDate | null;
    time: string | null;
    timeZone?: string;
    title: string;
    type: 'start' | 'end';
    validationError?: string;
}
//# sourceMappingURL=datetime-range-types.d.ts.map