import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { DatetimeRangeControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class DatetimeRangeDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = DatetimeRangeControlObject;
    }
}
/**
 * Initializes the decorated member as a [DatetimeRange]{@link DatetimeRangeControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DatetimeRange]{@link DatetimeRangeControlObject} field will be initialized with.
 */
export function dateTimeRangeField(properties) {
    return standardDecoratorImplementation(properties, DatetimeRangeDecorator, FieldKey.DatetimeRange, true);
}
export function dateTimeRangeFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=datetime-range-decorator.js.map