/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { DateControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class DateDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = DateControlObject;
    }
}
/**
 * Initializes the decorated member as a [Date]{@link DateControlObject} field with the provided properties
 *
 * @param properties The properties that the [Date]{@link DateControlObject} field will be initialized with
 */
export function dateField(properties) {
    return standardDecoratorImplementation(properties, DateDecorator, FieldKey.Date);
}
export function dateFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=date-decorator.js.map