/**
 * @packageDocumentation
 * @module root
 * */
import type { DatePropertyValue } from '../../../utils/types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { ScreenExtension } from '../../../types';
import type { ScreenBase } from '../../../service/screen-base';
/**
 * [Field]{@link EditableFieldControlObject} that holds a date value in the YYYY-MM-DD format
 */
export declare class DateControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Date, FieldComponentProps<FieldKey.Date>> {
    /** The maximum date value allowed for the date field */
    get maxDate(): DatePropertyValue | undefined;
    /** The maximum date value allowed for the date field */
    set maxDate(newValue: DatePropertyValue | undefined);
    /** The minimum date value allowed for the date field */
    get minDate(): DatePropertyValue | undefined;
    /** The minimum date value allowed for the date field */
    set minDate(newValue: DatePropertyValue | undefined);
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Moves the browser focus to this field */
    focus(): void;
}
//# sourceMappingURL=date-control-object.d.ts.map