import type { LocalizeLocale } from '@sage/xtrem-shared';
import React from 'react';
import type { CellParams } from '../../../utils/ag-grid/ag-grid-column-config';
import type { NestedDateProperties } from './date-types';
type EventTargetOnDateChange = {
    value: {
        formattedValue: string;
        rawValue: string;
    };
};
interface DateEditorState {
    value: string;
    highlightOnFocus: boolean;
    rawValue: string;
    locale: LocalizeLocale;
}
export default class DateCellEditor extends React.Component<CellParams<NestedDateProperties>, DateEditorState> {
    constructor(props: CellParams<NestedDateProperties>);
    componentDidMount(): void;
    handleChange(event: React.ChangeEvent<EventTargetOnDateChange>): void;
    onKeyDown(event: React.KeyboardEvent): void;
    getFormattedDate: () => string;
    getCarbonProps: () => any;
    createInitialState(props: CellParams<NestedDateProperties>): DateEditorState;
    render(): React.ReactNode;
}
export {};
//# sourceMappingURL=date-cell-editor.d.ts.map