/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { CountControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class CountDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = CountControlObject;
    }
}
/**
 * Initializes the decorated member as a [Count]{@link CountControlObject} field with the provided properties
 *
 * @param properties The properties that the [Count]{@link CountControlObject} field will be initialized with
 */
export function countField(properties) {
    return standardDecoratorImplementation(properties, CountDecorator, FieldKey.Count, true);
}
export function countFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=count-decorator.js.map