/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { showToast } from '../../../service/toast-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { isNil } from 'lodash';
/**
 * [Field]{@link AbstractField} that holds a reference to an existing GraphQL object. The type of GraphQL object
 * must be specified through the 'node' property, while the 'valueField' and 'helperTextField'
 * properties define which properties of the GraphQL object will be displayed in the field
 * and will be matched against the user provided text
 */
export class CountControlObject extends EditableFieldControlObject {
    /** Graphql filter that will restrict the results of the reference field */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh().catch(() => {
            /* Intentional fire and forget */
        });
    }
    /** Field's value */
    get value() {
        return this._getValue();
    }
    set value(newValue) {
        if (isNil(newValue)) {
            this._setValue(null);
        }
        else {
            this._setValue(newValue);
        }
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], CountControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Text to be displayed inline after the field value */
], CountControlObject.prototype, "prefix", void 0);
__decorate([
    ControlObjectProperty()
    /** Text to be displayed inline before the field value */
], CountControlObject.prototype, "postfix", void 0);
__decorate([
    ControlObjectProperty()
    /** Icon of the input field. It will be placed on the right side. */
], CountControlObject.prototype, "icon", void 0);
__decorate([
    ControlObjectProperty()
    /** Color of the icon, only supported in tile containers */
], CountControlObject.prototype, "iconColor", void 0);
//# sourceMappingURL=count-control-object.js.map