/**
 * @packageDocumentation
 * @module root
 * */
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link AbstractField} that holds a reference to an existing GraphQL object. The type of GraphQL object
 * must be specified through the 'node' property, while the 'valueField' and 'helperTextField'
 * properties define which properties of the GraphQL object will be displayed in the field
 * and will be matched against the user provided text
 */
export declare class CountControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Count, FieldComponentProps<FieldKey.Count>> {
    /** Graphql filter that will restrict the results of the reference field */
    get filter(): GraphQLFilter | undefined;
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter: GraphQLFilter | undefined);
    /** The helper text underneath the field */
    helperText?: string;
    /** Text to be displayed inline after the field value */
    prefix?: string;
    /** Text to be displayed inline before the field value */
    postfix?: string;
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /** Field's value */
    get value(): number | null;
    set value(newValue: number | null);
    refresh(): Promise<void>;
}
//# sourceMappingURL=count-control-object.d.ts.map