import * as React from 'react';
import { connect } from 'react-redux';
import { formatNumericValue } from '../../../utils/formatters';
import { CarbonWrapper } from '../carbon-wrapper';
import { mapDispatchToProps, mapStateToProps, ReadonlyFieldBaseComponent } from '../field-base-component';
import { isNil } from 'lodash';
export class CountComponent extends ReadonlyFieldBaseComponent {
    render() {
        const value = !isNil(this.props.value)
            ? formatNumericValue({ screenId: this.props.screenId, value: this.props.value })
            : null;
        return (React.createElement(CarbonWrapper, { ...this.props, className: "e-count-field", componentName: "count", componentRef: this.componentRef, fieldProperties: {
                ...this.props.fieldProperties,
                isReadOnly: true,
            }, handlersArguments: this.props.handlersArguments, value: value },
            React.createElement("noscript", null)));
    }
}
export const ConnectedCountComponent = connect(mapStateToProps(), mapDispatchToProps())(CountComponent);
export default ConnectedCountComponent;
//# sourceMappingURL=count-component.js.map