import React from 'react';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { splitValueToMergedValue } from '../../../utils/transformers';
export const CountCellRenderer = React.memo(props => {
    const { screenId, fieldProperties } = props;
    const prefix = resolveByValue({
        fieldValue: `${props.value?.query?.totalCount}`,
        propertyValue: fieldProperties.prefix,
        rowValue: splitValueToMergedValue(props.data),
        skipHexFormat: true,
        screenId,
    });
    const postfix = resolveByValue({
        fieldValue: `${props.value?.query?.totalCount}`,
        propertyValue: fieldProperties.postfix,
        rowValue: splitValueToMergedValue(props.data),
        skipHexFormat: true,
        screenId,
    });
    return (React.createElement(fieldProperties.wrapper, { ...props },
        React.createElement("div", { className: "e-count-field" },
            React.createElement("span", { className: "e-count-field-prefix" }, prefix),
            React.createElement("span", { className: "e-count-field-value" }, props.value?.query?.totalCount),
            React.createElement("span", { className: "e-count-field-postfix" }, postfix))));
});
//# sourceMappingURL=count-cell-renderer.js.map