import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { ContentTableControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class ContentTableDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = ContentTableControlObject;
    }
}
/**
 * Initializes the decorated member as a [ContentTable]{@link ContentTableControlObject} field with the provided properties
 *
 * @param properties The properties that the [ContentTable]{@link ContentTableControlObject} field will be initialized with
 */
export function contentTable(properties) {
    return standardDecoratorImplementation(properties, ContentTableDecorator, FieldKey.ContentTable);
}
export function contentTableOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=content-table-decorator.js.map