var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { CollectionValue } from '../../service/collection-data-service';
import { fetchNestedDefaultValues } from '../../service/graphql-service';
import { showToast } from '../../service/toast-service';
import { xtremConsole } from '../../utils/console';
import { getNestedFieldsFromProperties } from '../../utils/nested-field-utils';
import { resolveByValue } from '../../utils/resolve-value-utils';
import { splitValueToMergedValue } from '../../utils/transformers';
import { ControlObjectProperty } from '../property-decorators/control-object-property-decorator';
import { ReadonlyFieldControlObject } from '../readonly-field-control-object';
export class CollectionValueControlObject extends ReadonlyFieldControlObject {
    constructor(properties) {
        super(properties);
        this.createCollectionValue = (value, filter) => {
            const columns = getNestedFieldsFromProperties(this.uiComponentProperties);
            return new CollectionValue({
                bind: this.uiComponentProperties.bind,
                screenId: this.screenId,
                elementId: this.elementId,
                isTransient: !!this.getUiComponentProperty('isTransient'),
                hasNextPage: false,
                orderBy: [this.getUiComponentProperty('orderBy')],
                columnDefinitions: [columns],
                nodes: [this.getUiComponentProperty('node')],
                mapServerRecordFunctions: [this.getUiComponentProperty('mapServerRecord')],
                filter: [filter],
                initialValues: value,
            });
        };
        this._isFieldDirty = properties.isFieldDirty;
        this._setFieldDirty = properties.setFieldDirty;
        this._setFieldClean = properties.setFieldClean;
    }
    ensureFieldHasValue() {
        let value = this._getValue();
        if (!value) {
            value = this.createCollectionValue([], this.filter);
            this._setValue(value);
        }
        return value;
    }
    /** Graphql filter that will restrict the records displayed in the table */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the records displayed in the table */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh(true).catch(() => {
            /* Intentional fire and forget */
        });
    }
    get isDirty() {
        return this._isFieldDirty(this.screenId, this.elementId);
    }
    set isDirty(newValue) {
        if (newValue) {
            this._setFieldDirty(this.screenId, this.elementId);
        }
        else {
            this._setFieldClean(this.screenId, this.elementId);
        }
    }
    /**
     * Indicate additional warning message, rendered as tooltip and blue border.
     */
    get infoMessage() {
        return resolveByValue({
            fieldValue: this.value,
            propertyValue: this.getUiComponentProperty('infoMessage'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /**
     * Indicate additional warning message, rendered as tooltip and blue border.
     */
    set infoMessage(infoMessage) {
        this.setUiComponentProperties('infoMessage', infoMessage);
    }
    /**
     * Indicate additional information, rendered as tooltip and orange border
     */
    get warningMessage() {
        return resolveByValue({
            fieldValue: this.value,
            propertyValue: this.getUiComponentProperty('warningMessage'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /**
     * Indicate additional information, rendered as tooltip and orange border
     */
    set warningMessage(warningMessage) {
        this.setUiComponentProperties('warningMessage', warningMessage);
    }
    /**
     * Return all table records known to the client, it does not include records which were not previously fetched by some
     * user interaction such as pagination
     * */
    get value() {
        const value = this._getValue();
        if (!value) {
            return [];
        }
        return value.getFormattedActiveRecords();
    }
    /**
     * Resets the value of the table, all pending changes are be overridden and all cached records are discarded
     * */
    set value(newValue) {
        if (!this.getUiComponentProperty('isTransient')) {
            xtremConsole.warn('Reassigning table values is discouraged. Please update individual records using the setRecordValue(), addRecord(), removeRecord() functions.');
        }
        const filter = this.getUiComponentProperty('filter');
        this._setValue(this.createCollectionValue(newValue, typeof filter !== 'function' ? filter : undefined));
    }
    async revalidate(fn) {
        const value = this._getValue();
        if (!value) {
            return;
        }
        const invalidateValidationState = (invalidRecord, shouldNotifySubscribers = false) => {
            value.addOrUpdateRecordValue({
                recordData: { ...invalidRecord, __validationState: {} },
                level: invalidRecord.__level,
                shouldNotifySubscribers,
                includeUnloaded: true,
            });
        };
        value.getInvalidUnloadedRecords().forEach(unloadedRecord => invalidateValidationState(unloadedRecord));
        const invalidLoadedeRecord = value.getInvalidLoadedRecords().filter(fn);
        invalidLoadedeRecord.forEach(record => {
            invalidateValidationState(record, true);
        });
        await Promise.all(invalidLoadedeRecord.map(recordData => value.runValidationOnRecord({ recordData })));
    }
    /** Update the value of a single record in the collection */
    setRecordValue(recordData) {
        const value = this.ensureFieldHasValue();
        value.setRecordValue({ recordData });
    }
    /** Return a single record that is already known to the client */
    getRecordValue(recordId) {
        this.ensureFieldHasValue();
        const value = this._getValue();
        if (!value) {
            return null;
        }
        return splitValueToMergedValue(value.getRawRecord({ id: recordId }));
    }
    /** Return a single record that is already known to the client along with all its internal properties */
    getInternalRowValue(recordId) {
        this.ensureFieldHasValue();
        const value = this._getValue();
        if (!value) {
            return null;
        }
        return value.getRawRecord({ id: recordId, cleanMetadata: false });
    }
    /** Add a single record in the table and in its dataset */
    addRecord(recordData) {
        return this.addOrUpdateRecordValue(recordData);
    }
    /** Add a single record in the table and in its dataset with default values coming from the server */
    async addRecordWithDefaults(recordData) {
        const value = this.ensureFieldHasValue();
        const fetchedRecordValue = await fetchNestedDefaultValues({
            screenId: this.screenId,
            elementId: this.elementId,
            data: recordData,
        });
        delete fetchedRecordValue.nestedDefaults._id;
        return value.addOrUpdateRecordValue({ recordData: { ...recordData, ...fetchedRecordValue.nestedDefaults } });
    }
    /** Add or update record in the table depending of the existence of the ID field */
    addOrUpdateRecordValue(recordData) {
        const value = this.ensureFieldHasValue();
        return splitValueToMergedValue(value.addOrUpdateRecordValue({
            recordData,
        }));
    }
    /** Remove a single record from the table and its dataset */
    removeRecord(recordId) {
        const value = this.ensureFieldHasValue();
        value.removeRecord({ recordId });
    }
    /** Gets a record by a given field and value */
    getRecordByFieldValue(fieldName, fieldValue) {
        const value = this.ensureFieldHasValue();
        return value.getRawRecordByFieldValue({ fieldName: String(fieldName), fieldValue });
    }
    /** Selected records identifiers */
    get selectedRecords() {
        this.ensureFieldHasValue();
        const propertyValue = this.getUiComponentProperty('selectedRecords');
        return propertyValue || [];
    }
    /** Selected records identifiers */
    set selectedRecords(recordIds) {
        this.ensureFieldHasValue();
        this.setUiComponentProperties('selectedRecords', [...recordIds]);
    }
    /** Adds the record identifier to the set of selected items */
    selectRecord(recordId) {
        this.ensureFieldHasValue();
        const recordIds = this.selectedRecords;
        if (recordIds.indexOf(String(recordId)) === -1) {
            this.setUiComponentProperties('selectedRecords', [...recordIds, String(recordId)]);
        }
    }
    /** Removes the record identifier from the set of selected items */
    unselectRecord(recordId) {
        this.ensureFieldHasValue();
        const recordIds = this.selectedRecords;
        const recordIdIndex = recordIds.indexOf(String(recordId));
        if (recordIdIndex !== -1) {
            const updatedRecordIds = [...recordIds];
            updatedRecordIds.splice(recordIdIndex, 1);
            this.setUiComponentProperties('selectedRecords', updatedRecordIds);
        }
    }
    /** Unselects all items in the collection */
    unselectAllRecords() {
        this.ensureFieldHasValue();
        this.setUiComponentProperties('selectedRecords', []);
    }
    /** Returns an auto-generated ID that can be used for a new record */
    generateRecordId() {
        const value = this.ensureFieldHasValue();
        return value.generateIndex();
    }
    async refresh(keepModifications = false) {
        await this._refresh({ keepPageInfo: true, keepModifications }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result
     */
    async validate() {
        const validationResult = await this.validateWithDetails();
        return validationResult.map(v => v.message);
    }
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    async validateWithDetails() {
        const value = this._getValue();
        if (value) {
            return value.validate();
        }
        return [];
    }
    async refreshRecord(recordId, skipUpdate = false) {
        const value = this.ensureFieldHasValue();
        return value.refreshRecord({ recordId, skipUpdate });
    }
    /**
     * Calculate aggregated values ('min' | 'max' | 'sum' | 'avg' | 'count').
     * Returns Number.NaN if not all records have been fetched from the server.
     */
    calculateAggregatedValue({ aggregationKey, aggregationMethod, level, parentId, }) {
        const value = this.ensureFieldHasValue();
        return value.calculateAggregatedValue({
            aggregationKey,
            aggregationMethod,
            level,
            parentId,
        });
    }
}
__decorate([
    ControlObjectProperty()
    /** Number of lines displayed by default in the table, if not defined it defaults to 20 */
], CollectionValueControlObject.prototype, "pageSize", void 0);
__decorate([
    ControlObjectProperty()
    /** Whether the records of this table can be selected or not */
], CollectionValueControlObject.prototype, "canSelect", void 0);
//# sourceMappingURL=collection-value-field.js.map