import type { BaseErrorableComponentProperties, NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { EditableFieldProperties } from '../../editable-field-control-object';
import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedClickable, Sizable, Validatable } from '../traits';
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import type { BlockControlObject } from '../../control-objects';
import type { FieldControlObjectInstance } from '../../types';
export interface CheckboxProperties<CT extends ScreenBase = ScreenBase, ContextNodeType = void> extends EditableFieldProperties<CT, ContextNodeType> {
}
export interface CheckboxDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<CheckboxProperties<CT>, '_controlObjectType'>, Clickable<CT>, Changeable<CT>, Sizable, ExtensionField<CT, FieldControlObjectInstance<any>>, Validatable<CT>, HasParent<CT, BlockControlObject<CT>> {
    isReversed?: boolean;
}
export interface NestedCheckboxProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends Omit<CheckboxProperties<CT, ContextNodeType>, 'bind'>, Nested<ContextNodeType>, NestedChangeable<CT>, NestedClickable<CT>, Sizable {
    isReversed?: boolean;
}
export type CheckboxComponentProps = BaseErrorableComponentProperties<CheckboxProperties, boolean, NestedFieldsAdditionalProperties>;
//# sourceMappingURL=checkbox-types.d.ts.map