import type { LocalizeLocale } from '@sage/xtrem-shared';
import { FieldKey } from '@sage/xtrem-shared';
import { ChartTypes } from '../../chart-types';
import type { ChartProperties } from './chart-types';
import type { GraphqlCollection } from '../../types';
import type { NestedField, NestedFieldTypes } from '../../nested-fields';
export declare const chartColors: string[];
export interface ChartOptions {
    screenId: string;
    locale: LocalizeLocale;
    type: ChartTypes;
    isLegendHidden: boolean;
    data: any[];
    height: number;
    series?: {
        stroke: string;
        xKey: string;
        yKey: string;
        yName: string;
        seriesNestedField: NestedField<any, FieldKey.Numeric>;
    }[];
    pie?: {
        labelKey: string;
        angleKey: string;
        stroke: string;
        fills: string[];
        valueNestedField: NestedField<any, FieldKey.Numeric>;
    };
    labelNestedField: NestedField<any, NestedFieldTypes>;
    legend: {
        enabled: boolean;
        position: string;
    };
    xAxis: {
        key: string;
    };
}
export declare function getChartOptions({ screenId, properties, locale, collection, }: {
    screenId: string;
    properties: ChartProperties;
    locale: LocalizeLocale;
    collection?: GraphqlCollection;
}): ChartOptions;
export declare function formatChartLabel({ screenId, nestedField, locale, value, rowValue, }: {
    screenId: string;
    nestedField: NestedField<any, NestedFieldTypes>;
    locale: LocalizeLocale;
    value: any;
    rowValue: any;
}): string;
//# sourceMappingURL=chart-utils.d.ts.map