import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedChartComponent = React.lazy(() => import('./chart-component'));
export function AsyncConnectedChartComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedChartComponent, { ...props })));
}
const ChartComponent = React.lazy(() => import('./chart-component').then(c => ({ default: c.ChartComponent })));
export function AsyncChartComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(ChartComponent, { ...props })));
}
//# sourceMappingURL=async-chart-component.js.map