/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { CardProperties } from './card-types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export declare class CardControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.Card, FieldComponentProps<FieldKey.Card, CT, NodeType>> {
    static readonly defaultUiProperties: Partial<CardProperties>;
    /** The GraphQL node that the field suggestions will be fetched from */
    get node(): string;
    /** The helper text underneath the field */
    helperText?: string;
    refresh(): Promise<void>;
    focus(): void;
}
//# sourceMappingURL=card-control-object.d.ts.map