/**
 * @packageDocumentation
 * @module root
 * */
import { showToast } from '../../../service/toast-service';
import { datePropertyValueToDateString } from '@sage/xtrem-date-time';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import { CollectionValueControlObject } from '../collection-value-field';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a calendar
 */
export class CalendarControlObject extends CollectionValueControlObject {
    static { this.defaultUiProperties = {
        ...ReadonlyFieldControlObject.defaultUiProperties,
        canFilter: true,
    }; }
    /** Graphql filter that will restrict the events displayed in the calendar */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the events displayed in the calendar */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh().catch(() => {
            /* Intentional fire and forget */
        });
    }
    /** The maximum date the user is allowed to navigate */
    get maxDate() {
        return this.getUiComponentProperty('maxDate');
    }
    /** The maximum date the user is allowed to navigate */
    set maxDate(newValue) {
        const date = newValue ? datePropertyValueToDateString(newValue, true) : newValue;
        this.setUiComponentProperties('maxDate', date);
    }
    /** The minimum date the user is allowed to navigate */
    get minDate() {
        return this.getUiComponentProperty('minDate');
    }
    /** The minimum date the user is allowed to navigate */
    set minDate(newValue) {
        const date = newValue ? datePropertyValueToDateString(newValue, true) : newValue;
        this.setUiComponentProperties('minDate', date);
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
}
//# sourceMappingURL=calendar-control-object.js.map