/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { DatePropertyValue } from '../../../utils/types';
import type { NestedFieldTypes } from '../../nested-fields';
import type { FieldKey } from '../../types';
import { CollectionValueControlObject } from '../collection-value-field';
import type { CalendarProperties } from './calendar-types';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a calendar
 */
export declare class CalendarControlObject<CT extends ScreenExtension<CT> = ScreenBase, CalendarEventType extends ClientNode = any> extends CollectionValueControlObject<FieldKey.Calendar, CalendarEventType, CT, NestedFieldTypes, CalendarProperties<CT, CalendarEventType>> {
    static readonly defaultUiProperties: Partial<CalendarProperties>;
    /** Graphql filter that will restrict the events displayed in the calendar */
    get filter(): GraphQLFilter<CalendarEventType> | undefined;
    /** Graphql filter that will restrict the events displayed in the calendar */
    set filter(filter: GraphQLFilter<CalendarEventType> | undefined);
    /** The maximum date the user is allowed to navigate */
    get maxDate(): DatePropertyValue | undefined;
    /** The maximum date the user is allowed to navigate */
    set maxDate(newValue: DatePropertyValue | undefined);
    /** The minimum date the user is allowed to navigate */
    get minDate(): DatePropertyValue | undefined;
    /** The minimum date the user is allowed to navigate */
    set minDate(newValue: DatePropertyValue | undefined);
    refresh(): Promise<void>;
}
//# sourceMappingURL=calendar-control-object.d.ts.map