import { kebabCase } from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { getGraphQLFilter } from '../../../service/filter-service';
import { showToast } from '../../../service/toast-service';
import { getScreenElement } from '../../../service/screen-base-definition';
import { refreshField } from '../../../service/field-state-service';
import { getPropertyScalarType } from '../../../utils/abstract-fields-utils';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { findDeepPropertyType } from '../../../utils/node-utils';
import { schemaTypeNameFromNodeName } from '../../../utils/transformers';
import { FieldKey } from '../../types';
import { FiltersComponent, FiltersLabels } from '../../ui/filter/filters-component';
import { HelperText } from '../carbon-utility-components';
import { mapReadonlyStateToProps, ReadonlyFieldBaseComponent } from '../field-base-component';
import { FieldHeader } from '../field-header';
import { AsyncCalendarBodyComponent } from '../../ui/calendar-body/async-calendar-body-component';
import { CalendarViewSelector } from '../../ui/calendar-body/calendar-view-selector';
export class CalendarComponent extends ReadonlyFieldBaseComponent {
    constructor(props) {
        super(props);
        this.onFilterChange = () => {
            const nestedFields = this.getEventItems();
            const filter = getGraphQLFilter(this.state.filters, nestedFields);
            if (this.props.setFieldProperties) {
                this.props.setFieldProperties(this.props.elementId, {
                    ...this.props.fieldProperties,
                    activeUserFilter: filter,
                });
            }
            return refreshField({
                screenId: this.props.screenId,
                elementId: this.props.elementId,
                keepPageInfo: true,
            }).catch(e => {
                showToast(e.message || e, { type: 'warning' });
            });
        };
        this.saveFilters = async (filters) => {
            this.setState({ filters }, () => this.onFilterChange());
        };
        this.onSelectView = (selectedView) => {
            this.setState({
                selectedView,
            });
        };
        this.getTypedEventItems = (listItem, node) => {
            return Object.keys(listItem)
                .filter(key => listItem[key])
                .map(key => {
                const nestedField = listItem[key];
                const fieldType = findDeepPropertyType(schemaTypeNameFromNodeName(node), nestedField.properties.bind, this.props.nodeTypes, true)?.type || FieldKey.Text;
                return {
                    type: nestedField.type,
                    properties: {
                        ...nestedField.properties,
                        type: getPropertyScalarType(this.props.nodeTypes, fieldType, nestedField.type, nestedField.properties.valueField),
                    },
                };
            });
        };
        this.getEventItems = () => {
            const listItem = this.props.fieldProperties.eventCard;
            const node = this.props.fieldProperties.node;
            return this.getTypedEventItems(listItem, node);
        };
        this.state = {
            filters: [],
            selectedView: 'dayGridMonth',
            firstRender: true,
            selectedRecordId: this.props.selectedRecordId,
        };
    }
    render() {
        // IG: If the calendar is init as hidden it will not render correctly when changed to not hidden.
        // TODO: We should do that only in the FIRST render. After that we will use the display: none used on
        // getComponentClassx
        if (this.getResolvedProperty('isHidden') && this.state.firstRender) {
            return null;
        }
        return (React.createElement("div", { ...this.getBaseAttributesDivWrapper('calendar', `e-calendar-field e-calendar-field-type-${kebabCase(String(this.state.selectedView))}`, this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested) },
            React.createElement(FieldHeader, { elementId: this.props.elementId, screenId: this.props.screenId, title: this.getTitle(), isDisabled: this.isDisabled(), isTitleHidden: this.props.fieldProperties.isTitleHidden },
                this.props.isGreaterThanSmall && (React.createElement(CalendarViewSelector, { onSelectView: this.onSelectView, selectedView: this.state.selectedView })),
                this.props.fieldProperties.canFilter && this.props.fieldProperties.node && (React.createElement(FiltersComponent, { screenId: this.props.screenId, fields: this.getEventItems(), handleSave: this.saveFilters, filters: this.state.filters, isDisabled: this.isDisabled() }))),
            this.props.fieldProperties.canFilter && (React.createElement(FiltersLabels, { screenId: this.props.screenId, fields: this.getEventItems(), handleSave: this.saveFilters, filters: this.state.filters, isDisabled: this.isDisabled() })),
            React.createElement(AsyncCalendarBodyComponent, { cardColor: this.props.fieldProperties.cardColor, elementId: this.props.elementId, endDateField: this.props.fieldProperties.endDateField, eventCard: this.props.fieldProperties.eventCard, fieldProperties: this.props.fieldProperties, fixedHeight: this.props.fixedHeight, isGreaterThanSmall: this.props.isGreaterThanSmall, screenId: this.props.screenId, selectedView: this.state.selectedView, startDateField: this.props.fieldProperties.startDateField, value: this.props.value }),
            this.props.fieldProperties.helperText && (React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText }))));
    }
}
const mapStateToProps = (state, props) => {
    const componentProperties = mapReadonlyStateToProps()(state, props);
    if (componentProperties.fieldProperties.onDayClick) {
        componentProperties.fieldProperties.onDayClick = componentProperties.fieldProperties.onDayClick.bind(getScreenElement(state.screenDefinitions[props.screenId]));
    }
    if (componentProperties.fieldProperties.onEventClick) {
        componentProperties.fieldProperties.onEventClick = componentProperties.fieldProperties.onEventClick.bind(getScreenElement(state.screenDefinitions[props.screenId]));
    }
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    return {
        isGreaterThanSmall: state.browser.greaterThan.s,
        ...props,
        ...componentProperties,
        loading: state.loading.globalLoading,
        selectedRecordId: pageDefinition.selectedRecordId,
        setFieldProperties: xtremRedux.actions.actionStub,
        nodeTypes: state.nodeTypes,
    };
};
const mapDispatchToProps = (dispatch, props) => ({
    setFieldProperties: (elementId, value) => {
        dispatch(xtremRedux.actions.setFieldProperties(props.screenId, elementId, value));
    },
});
export const ConnectedCalendarComponent = connect(mapStateToProps, mapDispatchToProps)(CalendarComponent);
export default ConnectedCalendarComponent;
//# sourceMappingURL=calendar-component.js.map