/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { ButtonControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
class ButtonDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = ButtonControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [Button]{@link ButtonControlObject} field with the provided properties
 *
 * @param properties The properties that the [Button]{@link ButtonControlObject} field will be initialized with
 */
export function buttonField(properties) {
    return standardDecoratorImplementation(properties, ButtonDecorator, FieldKey.Button);
}
export function buttonFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=button-decorator.js.map