import type { BaseReadonlyComponentProperties, NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { HasFilter, HasPlaceholder, HasScale, Postfixable, Prefixable, Clickable, ExtensionField, HasHelperText, HasParent, Sizable, Nested, NestedClickable, HasIcon } from '../traits';
import type { ReadonlyFieldProperties } from '../../readonly-field-control-object';
import type { ClientCollection, ClientNode } from '@sage/xtrem-client';
import type { AggregationMethod, FieldControlObjectInstance } from '../../types';
import type { BlockControlObject, TileControlObject } from '../../control-objects';
import type { ScreenBase } from '../../../service/screen-base';
export type AggregateComponentProps = BaseReadonlyComponentProperties<AggregateProperties, number, NestedFieldsAdditionalProperties>;
export type AggregateValuesSelector<T> = T extends ClientCollection<any> ? void : T extends object ? {
    [K in keyof T]?: T[K] extends (infer U)[] ? AggregateValuesSelector<U> : AggregateValuesSelector<T[K]>;
} : true;
export interface AggregateProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends ReadonlyFieldProperties<CT>, Postfixable<CT>, Prefixable<CT>, Sizable, HasPlaceholder, HasIcon, HasScale<CT, ReferencedItemType>, HasFilter<CT, ReferencedItemType> {
    /** The child collection that is the subject of the aggregation query */
    aggregateOn: keyof ReferencedItemType | AggregateValuesSelector<ReferencedItemType>;
    /** The calculation method of the aggregation */
    aggregationMethod: AggregationMethod;
}
export interface AggregateDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<AggregateProperties<CT, ReferencedItemType>, '_controlObjectType'>, Clickable<CT>, HasParent<CT, BlockControlObject<CT> | TileControlObject<CT>>, HasHelperText, ExtensionField<CT, FieldControlObjectInstance<any>>, Sizable {
}
export interface NestedAggregateProperties<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> extends Omit<AggregateProperties<CT, NodeType>, 'bind'>, NestedClickable<CT>, Nested<NodeType>, Sizable {
}
//# sourceMappingURL=aggregate-types.d.ts.map