import { AbstractLayoutBuilder } from '../../abstract-layout-builder';
// TODO: StickerLayout it's the exact same code as page-layout.
export class StickerLayout extends AbstractLayoutBuilder {
    constructor() {
        super(...arguments);
        this.buildLayout = () => {
            return this.populateSections().populateBlocks().populateFields();
        };
        this.populateFields = () => {
            Object.keys(this.metadata.pageMetadata.fieldThunks).forEach(fieldId => {
                this.metadata.pageMetadata.fieldThunks[fieldId](this.nodeTypes, this.dataTypes);
                const fieldControlObject = this.metadata.pageMetadata.controlObjects[fieldId];
                if (fieldControlObject && fieldControlObject.parent) {
                    const parent = fieldControlObject.parent.apply(this.target.prototype).layout;
                    Object.keys(this.metadata.pageMetadata.layoutBlocks).forEach((blockId) => {
                        if (blockId === parent.$containerId) {
                            fieldControlObject.layout.$containerType = parent.$category;
                            this.metadata.pageMetadata.layoutBlocks[blockId].$layout.$items.push(fieldControlObject.layout);
                        }
                    });
                }
            });
            return this;
        };
        this.populateBlocks = () => {
            Object.keys(this.metadata.pageMetadata.blockThunks).forEach(blockId => {
                this.metadata.pageMetadata.blockThunks[blockId](this.nodeTypes, this.dataTypes);
                const blockControlObject = this.metadata.pageMetadata.controlObjects[blockId];
                if (blockControlObject && blockControlObject.parent) {
                    const parent = blockControlObject.parent.apply(this.target.prototype);
                    const parentId = parent.layout.$containerId;
                    Object.values(this.metadata.pageMetadata.layout.$items).forEach((section) => {
                        if (section.$containerId === parentId) {
                            section.$layout.$items.push(blockControlObject.layout);
                        }
                    });
                }
            });
            return this;
        };
        this.populateSections = () => {
            Object.keys(this.metadata.pageMetadata.sectionThunks).forEach((sectionId) => {
                this.metadata.pageMetadata.sectionThunks[sectionId](this.nodeTypes, this.dataTypes);
            });
            return this;
        };
    }
}
//# sourceMappingURL=sticker-layout.js.map