/**
 * @packageDocumentation
 * @module root
 * */
import { actions, getStore } from '../../../redux';
import { dispatchContainerValidation } from '../../../service/dispatch-service';
import { getPageMetadata } from '../../../service/page-metadata';
import { AbstractDecorator } from '../../abstract-decorator';
import { StickerControlObject } from '../../control-objects';
import { ContainerKey } from '../../types';
import { StickerLayout } from '../layouts';
class StickerDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._layout = StickerLayout;
        this._controlObjectConstructor = StickerControlObject;
        this.buildActions = () => {
            if (this._metadataProps.pageMetadata) {
                Object.keys(this._metadataProps.pageMetadata.pageActionThunks).forEach(k => {
                    this._metadataProps.pageMetadata.pageActions[k] = this._metadataProps.pageMetadata.pageActionThunks[k](this.nodeTypes, this.dataTypes);
                });
            }
            return this;
        };
    }
}
/**
 * Initializes the decorated member as a [Sticker]{@link StickerControlObject} container with the provided properties
 *
 * @param properties The properties that the [Sticker]{@link StickerControlObject} container will be initialized with
 */
export function sticker(properties) {
    return (ctor) => {
        const pageMetadata = getPageMetadata(ctor);
        const updateMenuItem = (badgeContent) => {
            const store = getStore();
            const thunkDispatch = store.dispatch;
            thunkDispatch(actions.updateMenuItem(pageMetadata.screenId, badgeContent));
        };
        pageMetadata.businessActionsThunk = properties.businessActions;
        new StickerDecorator(ctor, pageMetadata.screenId, { pageMetadata, properties }, ContainerKey.Sticker, {}, {}, {
            dispatchPageValidation: () => dispatchContainerValidation(pageMetadata.screenId, pageMetadata.screenId),
            updateMenuItem,
        }).build();
    };
}
//# sourceMappingURL=sticker-decorator.js.map