/**
 * @packageDocumentation
 * @module root
 * */
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { AbstractContainer } from '../../abstract-container';
import { ContainerKey } from '../../types';
/**
 * Main [container]{@link AbstractContainer} of each screen. Holds any number of [sections]{@link SectionControlObject}
 * and might define additional parts (e.g. crud actions, business actions, a helper panel, etc.)
 */
export class StickerControlObject extends AbstractContainer {
    constructor(properties) {
        // TODO: implement validation of the Sticker container. Send all fields
        super(properties.screenId, properties.screenId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.Sticker, properties.getValidationState || (async () => true), properties.layout);
        this._updateMenuItem = properties.updateMenuItem;
        this._dispatchPageValidation = properties.dispatchPageValidation;
    }
    // TODO Move this method to the abstract container
    /**
     * Triggers the validation rules of all the fields of the page. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    async validate() {
        const result = await this.validateWithDetails();
        return result.map(r => r.message);
    }
    async validateWithDetails(partition = false) {
        const errors = await this._dispatchPageValidation();
        return partition ? errors : errors.allErrors;
    }
    updateMenuItem(badgeContent) {
        this._updateMenuItem(badgeContent);
    }
}
//# sourceMappingURL=sticker-control-object.js.map