/**
 * @packageDocumentation
 * @module root
 * */
import type { ButtonProps } from 'carbon-react/esm/components/button';
import type { Extend } from '../../../service/page-extension';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { SectionProperties } from '../../control-objects';
import { SectionControlObject } from '../../control-objects';
import type { ExtensionField, VoidPromise } from '../../field/traits';
export interface SectionDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<SectionProperties<CT>, '_controlObjectType'>, ExtensionField<CT, SectionControlObject<CT>> {
    /** Function that gets executed when the section becomes active */
    onActive?: (this: CT) => VoidPromise;
    /** Function that gets executed when the section stops being active */
    onInactive?: (this: CT) => VoidPromise;
    /** Button label for the next button if this section is used in a wizard */
    wizardNextButtonLabel?: string;
    /** Button type for the next button if this section is used in a wizard */
    wizardNextButtonType?: ButtonProps['buttonType'];
    /** Button label for the previous button if this section is used in a wizard */
    wizardPreviousButtonLabel?: string;
    /** Button type for the previous button if this section is used in a wizard */
    wizardPreviousButtonType?: ButtonProps['buttonType'];
}
/**
 * Initializes the decorated member as a [Section]{@link SectionControlObject} container with the provided properties
 *
 * @param properties The properties that the [Section]{@link SectionControlObject} container will be initialized with
 */
export declare function section<CT extends ScreenExtension<CT>>(properties: SectionDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
//# sourceMappingURL=section-decorator.d.ts.map