/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ScreenExtension } from '../../../types';
import type { ContainerProperties } from '../../abstract-container';
import { AbstractContainer } from '../../abstract-container';
import type { ContainerComponentProps, ContainerControlObjectConstructorProps } from '../../types';
import { ContainerKey } from '../../types';
export interface SectionProperties<CT extends ScreenBase = ScreenBase> extends ContainerProperties<CT> {
    /** Whether the helper panel can be extracted into a separate window or not. Defaults to false */
    isExtendable?: boolean;
    /** Whether the section is open (uncollapsed) or not. Defaults to true */
    isOpen?: boolean;
    /** The display mode of the section. In accordion mode all blocks are displayed full width, regardless to their width configuration */
    mode?: 'normal' | 'accordion';
}
export interface ISectionControlObject extends ContainerControlObjectConstructorProps<ContainerKey.Section> {
    dispatchSectionValidation: () => Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
}
/**
 * [Container]{@link AbstractContainer} that holds any number of [blocks]{@link BlockControlObject}
 */
export declare class SectionControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.Section, ContainerComponentProps<ContainerKey.Section>> {
    insertBefore?: ContainerControlObjectConstructorProps<ContainerKey.Section>['insertBefore'];
    private readonly _dispatchSectionValidation;
    static readonly defaultUiProperties: Partial<SectionProperties>;
    constructor(properties: ISectionControlObject);
    /** Whether the section is collapsed (isOpen = false) or not (isOpen = true) */
    isOpen?: boolean;
    /**
     * Whether the section can be extended into a separate window (extendable = true)
     * or not (extendable = false)
     */
    isExtendable?: boolean;
    /**
     * Triggers the validation rules of all the fields of the section. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    validate(): Promise<string[]>;
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    validateWithDetails(partition: true): Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
    validateWithDetails(partition: false): Promise<ValidationResult[]>;
    validateWithDetails(): Promise<ValidationResult[]>;
}
//# sourceMappingURL=section-control-object.d.ts.map