import type { Dict } from '@sage/xtrem-shared';
import * as React from 'react';
import type { PageArticleItem } from '../../../service/layout-service';
import { ContextType } from '../../../types';
import type { LabelControlObject, PageActionControlObject, SectionProperties } from '../../control-objects';
import type { MenuSeparatorType, PageMode } from './page-types';
import type { CollectionValue } from '../../../service/collection-data-service';
export type StepStatus = 'complete' | 'current' | 'incomplete';
export interface XtremHeaderExternalProps {
    activeSection: string | null;
    areNavigationTabsHidden: boolean;
    availableColumns: number;
    contextType?: ContextType;
    hasNavigationPanel: boolean;
    headerLineBlock: Partial<PageArticleItem> | null;
    isRecordCreationPage?: boolean;
    navigationPanelValue?: CollectionValue;
    pageBodyRef: React.RefObject<HTMLDivElement>;
    screenId: string;
    setActiveSection: (sectionId: string) => void;
}
export interface XtremHeaderProps extends XtremHeaderExternalProps {
    canToggleNavigationPanel: boolean;
    has360View?: boolean;
    hasDropdownOrQuickActions: boolean;
    headerDropdownMenu?: Array<PageActionControlObject | MenuSeparatorType>;
    headerImage: string | null;
    headerLabelField?: LabelControlObject;
    headerSection: Partial<PageArticleItem> | null;
    headerTitle: string | null;
    hierarchyParentPage?: () => string | null;
    idFieldValue?: string | null;
    is360ViewOn: boolean;
    isHeaderImageNeeded: boolean;
    isNavigationPanelHeaderHidden: boolean;
    isNavigationPanelOpened: boolean;
    isNewPage: boolean;
    isTitleHidden?: boolean;
    objectTypePlural?: string | null;
    objectTypeSingular?: string | null;
    pageMode: PageMode;
    sections: Partial<PageArticleItem>[];
    sectionsProperties: Dict<SectionProperties>;
    sectionValidationErrors: Dict<string | null>;
    setNavigationPanelIsOpened: (isOpened: boolean) => void;
    shouldDisplayNavigationArrows: boolean;
    subtitle?: string;
    title: string;
}
export interface HeaderState {
    isHeaderSectionClosed?: boolean;
}
export declare class XtremHeader extends React.Component<XtremHeaderProps, HeaderState> {
    private readonly activeIndicator;
    private readonly tabContainer;
    private readonly tabDictionary;
    private readonly hotkeySubscriptions;
    private readonly parentRef;
    constructor(props: XtremHeaderProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: XtremHeaderProps): void;
    componentWillUnmount(): void;
    private setIndicatorPosition;
    private readonly getActiveSectionIndex;
    private readonly setActiveSectionByIndex;
    private readonly setActiveSection;
    private readonly hasTabs;
    private readonly getClasses;
    private readonly getVisibleTabs;
    private readonly onRecordClose;
    private readonly renderTabs;
    private readonly onHeaderSectionToggle;
    renderCloseIcon: () => React.ReactNode;
    renderHeaderToggleButton: () => React.ReactNode;
    private readonly renderTitleImage;
    render(): React.ReactNode;
}
export declare const ConnectedXtremHeader: import("react-redux").ConnectedComponent<typeof XtremHeader, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<XtremHeader> | undefined;
    activeSection: string | null;
    areNavigationTabsHidden: boolean;
    availableColumns: number;
    contextType?: ContextType | undefined;
    hasNavigationPanel: boolean;
    headerLineBlock: Partial<PageArticleItem> | null;
    isRecordCreationPage?: boolean | undefined;
    navigationPanelValue?: CollectionValue<any> | undefined;
    pageBodyRef: React.RefObject<HTMLDivElement>;
    screenId: string;
    setActiveSection: (sectionId: string) => void;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=xtrem-header.d.ts.map