import * as React from 'react';
import { useSelector } from 'react-redux';
import * as dialogService from '../../../service/dialog-service';
import { QUERY_PARAM_PRINTING_RECORD_ID, QUERY_PARAM_PRINTING_SOURCE_PAGE } from '../../../utils/constants';
import Button from 'carbon-react/esm/components/button';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import { localize } from '../../../service/i18n-service';
import Icon from 'carbon-react/esm/components/icon';
export function PrintRecordButton({ screenId }) {
    const printingSettings = useSelector(state => state.printingSettings);
    const selectedRecordId = useSelector(state => state.screenDefinitions[screenId]?.selectedRecordId || null);
    const openAssignmentDialog = React.useCallback(() => {
        if (!printingSettings?.recordPrintingAssignmentUrl) {
            throw new Error('recordPrintingAssignmentUrl is not defined');
        }
        dialogService.openPageDialog(printingSettings?.recordPrintingAssignmentUrl, { [QUERY_PARAM_PRINTING_SOURCE_PAGE]: screenId }, { resolveOnCancel: true, size: 'large' });
    }, [printingSettings?.recordPrintingAssignmentUrl, screenId]);
    const openPrintDialog = React.useCallback(() => {
        if (!printingSettings?.recordPrintingWizardUrl) {
            throw new Error('recordPrintingWizardUrl is not defined');
        }
        if (!selectedRecordId) {
            throw new Error('No record is selected');
        }
        dialogService.openPageDialog(printingSettings?.recordPrintingWizardUrl, { [QUERY_PARAM_PRINTING_SOURCE_PAGE]: screenId, [QUERY_PARAM_PRINTING_RECORD_ID]: selectedRecordId }, { resolveOnCancel: true, size: 'medium' });
    }, [printingSettings?.recordPrintingWizardUrl, screenId, selectedRecordId]);
    if (!selectedRecordId ||
        !printingSettings ||
        (!printingSettings.canAccessRecordPrintingAssignmentWizard && !printingSettings.canAccessRecordPrintingWizard)) {
        return null;
    }
    return (React.createElement(MultiActionButton, { buttonType: "tertiary", "aria-label": localize('@sage/xtrem-ui/table-print', 'Print'), text: (React.createElement(Icon, { type: "print", color: "var(--colorsActionMinor500)" })), "data-testid": "e-print-record-button", mr: "16px", mt: "-4px", size: "small", className: "e-print-record-button" },
        React.createElement(Button, { key: "assignment", disabled: !printingSettings.canAccessRecordPrintingAssignmentWizard, onClick: openAssignmentDialog, "data-testid": "e-print-record-assignment-button" }, localize('@sage/xtrem-ui/list-printing-assignment', 'Assign report')),
        React.createElement(Button, { key: "print", disabled: !printingSettings.canAccessRecordPrintingWizard, onClick: openPrintDialog, "data-testid": "e-print-record-wizard-button" }, localize('@sage/xtrem-ui/list-printing', 'Select report'))));
}
//# sourceMappingURL=print-record-button.js.map