import { getPageMetadata } from '../../../service/page-metadata';
import { AbstractDecorator } from '../../abstract-decorator';
import { PageFragmentControlObject } from '../../control-objects';
import { getTargetPrototype } from '../../../utils/decorator-utils';
import { injectOnloadAfterIntoPageMetadata } from '../../../utils/page-utils';
export class PageFragmentDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = PageFragmentControlObject;
    }
}
/**
 * Initializes the decorated member as a [Page]{@link PageFragmentControlObject} container with the provided properties
 *
 * @param properties The properties that the [Page]{@link PageFragmentControlObject} container will be initialized with
 */
export function pageFragment(properties) {
    return (ctor) => {
        // Get the main page metadata object
        const pageMetadata = getPageMetadata(getTargetPrototype(ctor));
        pageMetadata.pageFragmentThunks.push(() => {
            if (properties.onLoad) {
                injectOnloadAfterIntoPageMetadata(pageMetadata, properties.onLoad);
            }
        });
    };
}
//# sourceMappingURL=page-fragment-decorator.js.map