/**
 * @packageDocumentation
 * @module root
 * */
import type { ContainerValidationResult } from '../../../service/dispatch-service';
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ScreenExtension } from '../../../types';
import { AbstractContainer } from '../../abstract-container';
import type { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { ContainerComponentProps } from '../../types';
import { ContainerKey } from '../../types';
import type { IPageControlObject, PageMode, PageNavigationPanel, PageProperties } from './page-types';
/**
 * Main [container]{@link AbstractContainer} of each screen. Holds any number of [sections]{@link SectionControlObject}
 * and might define additional parts (e.g. crud actions, business actions, a helper panel, etc.)
 */
export declare class PageControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.Page, ContainerComponentProps<ContainerKey.Page>> {
    private readonly _dispatchPageValidation;
    private readonly _getFocussedField;
    static readonly defaultUiProperties: Partial<PageProperties>;
    constructor(properties: IPageControlObject);
    /** Visualization mode */
    get mode(): PageMode | undefined;
    /** Panel where to search, filter and navigate through current page related items */
    get navigationPanel(): PageNavigationPanel<any, any> | undefined;
    /**
     * The GraphQL node that the page is bind to. This settings will be omitted
     * if the page is set to be transient
     */
    get node(): string;
    get focussedField(): ReadonlyFieldControlObject<CT, any, any, any> | null;
    /** Subtitle displayed along with the page's title */
    subtitle?: string;
    /**
     * Triggers the validation rules of all the fields of the page. Since the validation rules
     * might be asynchronous, this method returns a promise that must be awaited to get
     * the validation result
     */
    validate(): Promise<string[]>;
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    validateWithDetails(partition: true): Promise<ContainerValidationResult>;
    validateWithDetails(partition: false): Promise<ValidationResult[]>;
    validateWithDetails(): Promise<ValidationResult[]>;
}
//# sourceMappingURL=page-control-object.d.ts.map