import * as React from 'react';
import { connect } from 'react-redux';
import { getPageDefinitionFromState, getPagePropertiesFromState } from '../../../utils/state-utils';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { MENU_SEPARATOR } from './page-types';
import XtremActionPopover from '../../ui/xtrem-action-popover';
import { triggerFieldEvent } from '../../../utils/events';
import * as tokens from '@sage/design-tokens/js/base/common';
import { getElementAccessStatus } from '../../../utils/access-utils';
export function HeaderDropdownActions({ headerDropdownActions, }) {
    if (!headerDropdownActions) {
        return null;
    }
    return (React.createElement("span", { className: "e-header-dropdown-action-container" },
        React.createElement(XtremActionPopover, { items: headerDropdownActions, noIconSupport: false, color: tokens.colorsUtilityMajor450, pendoId: "headerDropdownActions" })));
}
export const ConnectedHeaderDropdownActions = connect((state, props) => {
    const pageProperties = getPagePropertiesFromState(props.screenId, state);
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const headerDropdownActions = resolveByValue({
        skipHexFormat: true,
        screenId: props.screenId,
        propertyValue: pageProperties.headerDropDownActions,
        rowValue: null,
        fieldValue: null,
    });
    if (!headerDropdownActions) {
        return props;
    }
    const resolvedPopoverItems = headerDropdownActions.map(e => {
        if (e === MENU_SEPARATOR) {
            return e;
        }
        const actionProperties = pageDefinition.metadata.uiComponentProperties[e.id];
        const accessRule = getElementAccessStatus({
            accessBindings: pageDefinition.accessBindings,
            bind: e.id,
            elementProperties: actionProperties,
            contextNode: pageProperties?.node,
            nodeTypes: state.nodeTypes,
            dataTypes: state.dataTypes,
        });
        const isDisabled = resolveByValue({
            screenId: props.screenId,
            propertyValue: actionProperties.isDisabled,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        });
        const isHidden = resolveByValue({
            screenId: props.screenId,
            propertyValue: actionProperties.isHidden,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        }) ||
            (actionProperties.access && accessRule !== 'authorized');
        const title = resolveByValue({
            screenId: props.screenId,
            propertyValue: actionProperties.title,
            skipHexFormat: true,
            rowValue: null,
            fieldValue: null,
        });
        return {
            key: e.id,
            title,
            isDisabled,
            isHidden,
            icon: actionProperties.icon,
            isDestructive: actionProperties.isDestructive,
            pendoId: `${props.screenId}-headerDropdownAction-${e.id}`,
            onClick: () => {
                state.applicationContext?.onTelemetryEvent?.(`headerDropdownMenuItemTriggered-${e.id}`, {
                    screenId: props.screenId,
                    elementId: e.id,
                });
                return triggerFieldEvent(props.screenId, e.id, 'onClick');
            },
        };
    });
    return {
        ...props,
        headerDropdownActions: resolvedPopoverItems,
    };
})(HeaderDropdownActions);
//# sourceMappingURL=header-dropdown-actions.js.map