import React from 'react';
import { localize } from '../../../service/i18n-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { partition } from 'lodash';
import { ConnectedNestedFieldErrors } from '../../ui/nested-field-errors-component';
export function ContainerValidationErrorsComponent({ validationResults, pageMetadata, screenId, children, }) {
    const [nestedValidationErrors, nonNestedValidationErrors] = partition(validationResults, e => !!e.columnId);
    const nestedElementIds = Array.from(new Set(nestedValidationErrors.map(e => e.elementId)));
    return (React.createElement("div", { className: "e-page-validation-error-list" },
        React.createElement("h6", null, localize('@sage/xtrem-ui/validation-errors', 'Validation Errors')),
        React.createElement("ul", null,
            nonNestedValidationErrors.map(({ message, elementId }) => {
                const fieldProperties = pageMetadata.uiComponentProperties[elementId];
                const title = resolveByValue({
                    screenId: pageMetadata.screenId,
                    skipHexFormat: true,
                    propertyValue: fieldProperties.title,
                    rowValue: undefined,
                });
                return (React.createElement("li", { key: elementId },
                    React.createElement("p", null,
                        React.createElement("strong", null,
                            title || elementId,
                            ":"),
                        " ",
                        message)));
            }),
            nestedElementIds.map(elementId => {
                return (React.createElement("li", { key: elementId },
                    React.createElement(ConnectedNestedFieldErrors, { screenId: screenId, elementId: elementId })));
            }),
            children)));
}
//# sourceMappingURL=container-validation-errors.js.map