import ButtonMinor from 'carbon-react/esm/components/button-minor';
import * as React from 'react';
import { localize } from '../../../service/i18n-service';
function ToggleNavigationPanelButton(props) {
    const toggle = () => {
        props.setNavigationPanelIsOpened(!props.isNavigationPanelOpened);
        if (props.parentOnClick && props.parentRef) {
            props.parentOnClick(props.parentRef);
        }
    };
    const iconType = props.isNavigationPanelOpened ? 'chevron_left' : 'chevron_right';
    const label = localize('@sage/xtrem-ui/toggle-navigation-panel', 'Toggle Navigation Panel');
    return (React.createElement("div", { className: "e-navigation-panel-toggle" },
        React.createElement(ButtonMinor, { ref: props.parentRef, iconType: iconType, onClick: toggle, buttonType: "tertiary", size: "large", iconTooltipPosition: "bottom", iconTooltipMessage: label, "aria-label": label, "data-testid": `nav-panel-toggle-button-${props.isNavigationPanelOpened ? 'close' : 'open'}`, "data-pendoid": "closeNavigationPanel" })));
}
export default ToggleNavigationPanelButton;
//# sourceMappingURL=toggle-navigation-panel-button.js.map