/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import { GridRowBlockDecoratorProperties } from './grid-row-block-types';
export { GridRowBlockDecoratorProperties };
/**
 * Initializes the decorated member as a [Block]{@link GridRowBlockControlObject} container with the provided properties
 *
 * @param properties The properties that the [Block]{@link GridRowBlockControlObject} container will be initialized with
 */
export declare function gridRowBlock<CT extends ScreenExtension<CT>>(properties: GridRowBlockDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
export declare function gridRowBlockOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<GridRowBlockDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=grid-row-block-decorator.d.ts.map