/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { getUiComponentProperties, setUiComponentProperties } from '../../../service/transactions-service';
import { AbstractContainer } from '../../abstract-container';
import { FieldControlObjectResolvedProperty } from '../../property-decorators/control-object-resolved-property-decorator';
import { ContainerKey } from '../../types';
/**
 * [Container]{@link AbstractContainer} that holds any number of [fields]{@link AbstractField}
 */
export class GridRowBlockControlObject extends AbstractContainer {
    static { this.defaultUiProperties = {
        ...AbstractContainer.defaultUiProperties,
    }; }
    constructor(properties) {
        super(properties.screenId, properties.elementId, properties.getUiComponentProperties || getUiComponentProperties, properties.setUiComponentProperties || setUiComponentProperties, ContainerKey.GridRowBlock, properties.getValidationState || (async () => true), properties.layout, properties.parent);
        this.insertBefore = properties.insertBefore;
    }
    selectRowAndLevel(selectedRecordId, selectedLevel) {
        const fieldProperties = { ...this.uiComponentProperties, selectedRecordId, selectedLevel };
        this._setUiComponentProperties(this.screenId, this.elementId, fieldProperties);
    }
    async validateWithDetails(
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    _partition = false) {
        // Never used, but required by the AbstractContainer
        return [];
    }
}
__decorate([
    FieldControlObjectResolvedProperty()
], GridRowBlockControlObject.prototype, "selectedLevel", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
], GridRowBlockControlObject.prototype, "selectedRecordId", void 0);
//# sourceMappingURL=grid-row-block-control-object.js.map