/**
 * @packageDocumentation
 * @module root
 * */
import type { ScreenBase } from '../../../service/screen-base';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { ScreenExtension } from '../../../types';
import { AbstractContainer } from '../../abstract-container';
import type { ContainerComponentProps, ContainerControlObjectConstructorProps, ParentType } from '../../types';
import { ContainerKey } from '../../types';
import type { GridRowBlockProperties } from './grid-row-block-types';
export interface IGridRowBlockControlObject extends ContainerControlObjectConstructorProps<ContainerKey.GridRowBlock> {
    parent?: ParentType<ContainerKey.GridRowBlock>;
}
/**
 * [Container]{@link AbstractContainer} that holds any number of [fields]{@link AbstractField}
 */
export declare class GridRowBlockControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractContainer<CT, ContainerKey.GridRowBlock, ContainerComponentProps<ContainerKey.GridRowBlock>> {
    insertBefore?: ContainerControlObjectConstructorProps<ContainerKey.GridRowBlock>['insertBefore'];
    static readonly defaultUiProperties: Partial<GridRowBlockProperties>;
    theParentOfThisFieldNeedsToBeABlockContainer: boolean;
    constructor(properties: IGridRowBlockControlObject);
    selectedLevel?: number;
    selectedRecordId?: string;
    selectRowAndLevel(selectedRecordId: string, selectedLevel?: number): void;
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    validateWithDetails(partition: true): Promise<{
        allErrors: ValidationResult[];
        blockingErrors: ValidationResult[];
    }>;
    validateWithDetails(partition: false): Promise<ValidationResult[]>;
    validateWithDetails(): Promise<ValidationResult[]>;
}
//# sourceMappingURL=grid-row-block-control-object.d.ts.map