import * as React from 'react';
import { connect } from 'react-redux';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { isFieldDisabled } from '../../field/carbon-helpers';
import { ConnectedNestedBlock } from '../../ui/nested-block';
const getColumns = (screenId, columns, fieldFilter) => !fieldFilter
    ? columns
    : columns.filter(f => resolveByValue({
        screenId,
        propertyValue: fieldFilter,
        fieldValue: f.properties.bind,
        skipHexFormat: true,
        rowValue: null, // Here we don't have an individual context for each fields
    }));
export function GridRowBlockComponent(props) {
    if (!props.fieldProperties.selectedRecordId) {
        return null;
    }
    const columns = props.referredTableProperties.levels
        ? props.referredTableProperties.levels[props.fieldProperties.selectedLevel || 0]
            .columns
        : (props.referredTableProperties.columns || []).filter(column => !props.referredTableProperties.hiddenColumns?.find((c) => c === column.properties.bind));
    return (React.createElement(ConnectedNestedBlock, { availableColumns: props.availableColumns, contextNode: props.referredTableProperties?.node ? String(props.referredTableProperties.node) : undefined, contextType: props.contextType, item: props.item, nestedFields: getColumns(props.screenId, columns, props.fieldProperties.fieldFilter), parentElementId: props.parentElementId, recordId: props.fieldProperties.selectedRecordId, level: props.fieldProperties.selectedLevel, screenId: props.screenId, isHidden: props.fieldProperties.isHidden, isTitleHidden: props.fieldProperties.isTitleHidden, title: props.fieldProperties.title, readOnlyOverride: props.fieldProperties.readOnlyOverride, isDisabled: props.isParentDisabled || isFieldDisabled(props.screenId, props.fieldProperties, null, null), hideValidationSummary: true }));
}
const mapStateToProps = (state, props) => {
    const fieldProperties = state.screenDefinitions[props.screenId].metadata.uiComponentProperties[props.item.$containerId];
    const referredTable = resolveByValue({
        propertyValue: fieldProperties.boundTo,
        screenId: props.screenId,
        skipHexFormat: true,
        rowValue: null, // Static value, it cannot change on run time.
    });
    const parentElementId = referredTable.id;
    const referredTableProperties = state.screenDefinitions[props.screenId].metadata.uiComponentProperties[parentElementId];
    return {
        ...props,
        fieldProperties,
        screenType: state.screenDefinitions[props.screenId].type,
        browser: state.browser,
        referredTableProperties,
        parentElementId,
    };
};
export const ConnectedGridRowBlockComponent = connect(mapStateToProps)(GridRowBlockComponent);
export default ConnectedGridRowBlockComponent;
//# sourceMappingURL=grid-row-block-component.js.map