import Button from 'carbon-react/esm/components/button';
import Tooltip from 'carbon-react/esm/components/tooltip';
import * as React from 'react';
import { connect } from 'react-redux';
import { triggerFieldEvent } from '../../../utils/events';
import { getFieldTitle, isFieldDisabled, isFieldHidden } from '../../field/carbon-helpers';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { BusinessActionButtonWrapper } from './bussiness-action-button-wrapper';
import { getDataTestIdAttribute } from '../../../utils/dom';
export class BusinessAction extends React.Component {
    constructor(props) {
        super(props);
        this.onClick = () => {
            if (this.props.onClick) {
                this.props.onClick();
                if (!this.props.alwaysTriggerFieldEvent) {
                    // The multi action button registers an onClick prop even if we don't want it.
                    return;
                }
            }
            if (this.props.id) {
                triggerFieldEvent(this.props.screenId, this.props.id, 'onClick');
                this.props.onTelemetryEvent?.(`businessActionTriggered-${this.props.id}`, {
                    elementId: this.props.id,
                    screen: this.props.screenId,
                });
            }
        };
        this.setTooltipState = (tooltipShowing) => () => {
            if (this.props.helperText) {
                this.setState({ tooltipShowing });
            }
        };
        this.state = { tooltipShowing: false };
    }
    render() {
        const helperText = this.props.helperText;
        if (this.props.isHidden) {
            return null;
        }
        const isIconOnly = this.props.isIconOnly && this.props.icon;
        const button = (React.createElement(React.Fragment, null,
            React.createElement(Button, { ref: this.props.parentRef, buttonType: this.props.buttonType || this.props.defaultButtonType, disabled: this.props.isDisabled, destructive: this.props.isDestructive, iconType: this.props.icon, mr: this.props.isSeparated ? '8px' : undefined, onClick: this.onClick, 
                // onMouseEnter={this.setTooltipState(true)}
                // onMouseLeave={this.setTooltipState(false)}
                size: this.props.size || 'medium', iconTooltipMessage: isIconOnly ? this.props.title : undefined, "data-testid": this.props.skipWrapping
                    ? getDataTestIdAttribute('business-action', this.props.title, this.props.id)
                    : undefined, "data-pendoId": this.props.pendoId && this.props.id ? `${this.props.pendoId}-${this.props.id}` : undefined }, isIconOnly ? undefined : this.props.title),
            helperText && this.state.tooltipShowing && (React.createElement(Tooltip, { message: "" },
                React.createElement("span", null, helperText)))));
        if (this.props.skipWrapping) {
            return button;
        }
        return (React.createElement(BusinessActionButtonWrapper, { id: this.props.id, title: this.props.title }, button));
    }
}
const mapStateToProps = (state, props) => {
    if (!props.id) {
        throw new Error('Action id must be supplied when the business action used in connected mode');
    }
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const actionProperties = pageDefinition.metadata.uiComponentProperties[props.id];
    return {
        ...props,
        buttonType: props.buttonTypeOverride || actionProperties.buttonType,
        helperText: actionProperties.helperText,
        icon: actionProperties.icon,
        isDestructive: actionProperties.isDestructive,
        isHidden: isFieldHidden(props.screenId, actionProperties, null),
        isDisabled: isFieldDisabled(props.screenId, actionProperties, null, null),
        title: props.title || getFieldTitle(props.screenId, actionProperties, null),
        onTelemetryEvent: state.applicationContext?.onTelemetryEvent,
    };
};
export const ConnectedBusinessAction = connect(mapStateToProps)(BusinessAction);
ConnectedBusinessAction.displayName = 'Button';
export default ConnectedBusinessAction;
//# sourceMappingURL=business-action.js.map