import * as React from 'react';
import type { PageActionButtonType } from '../../control-objects';
import type { IconType } from 'carbon-react/esm/components/icon';
import type { OnTelemetryEventFunction } from '../../../redux/state';
export interface BusinessActionExternalProps {
    id?: string;
    screenId: string;
    defaultButtonType?: PageActionButtonType;
    buttonTypeOverride?: PageActionButtonType;
    isIconOnly?: boolean;
    onClick?: () => void;
    parentRef?: React.Ref<HTMLButtonElement>;
    size?: 'small' | 'medium';
    isSeparated?: boolean;
    alwaysTriggerFieldEvent?: boolean;
    skipWrapping?: boolean;
    pendoId?: string;
    title?: string;
}
export interface BusinessActionProps extends BusinessActionExternalProps {
    isHidden?: boolean;
    isDisabled?: boolean;
    isDestructive?: boolean;
    title?: string;
    icon?: IconType;
    helperText?: string;
    buttonType?: PageActionButtonType;
    onTelemetryEvent?: OnTelemetryEventFunction;
}
export interface BusinessActionState {
    tooltipShowing: boolean;
}
export declare class BusinessAction extends React.Component<BusinessActionProps, BusinessActionState> {
    constructor(props: BusinessActionProps);
    onClick: () => void;
    setTooltipState: (tooltipShowing: boolean) => () => void;
    render(): React.ReactNode;
}
export declare const ConnectedBusinessAction: import("react-redux").ConnectedComponent<typeof BusinessAction, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<BusinessAction> | undefined;
    id?: string | undefined;
    screenId: string;
    defaultButtonType?: PageActionButtonType;
    buttonTypeOverride?: PageActionButtonType;
    isIconOnly?: boolean | undefined;
    onClick?: (() => void) | undefined;
    parentRef?: React.Ref<HTMLButtonElement> | undefined;
    size?: "small" | "medium" | undefined;
    isSeparated?: boolean | undefined;
    alwaysTriggerFieldEvent?: boolean | undefined;
    skipWrapping?: boolean | undefined;
    pendoId?: string | undefined;
    title?: string | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default ConnectedBusinessAction;
//# sourceMappingURL=business-action.d.ts.map