import { useSelector } from 'react-redux';
import { getPageDefinition, getPagePropertiesFromPageDefinition } from '../../../utils/state-utils';
import { getPageTitlesFromPageDefinition } from '../../../utils/page-utils';
import Typography from 'carbon-react/esm/components/typography';
import * as React from 'react';
import { DialogBreadcrumbs } from './dialog-breadcrumbs';
import { QUERY_PARAM_TUNNEL_SEGMENTS } from '../../../utils/constants';
import IconButton from 'carbon-react/esm/components/icon-button';
import Icon from 'carbon-react/esm/components/icon';
import { getScreenElement } from '../../../service/screen-base-definition';
import FieldWrapper from '../../../render/field-wrapper';
import { ContextType } from '../../../types';
// eslint-disable-next-line react/function-component-definition
export const DialogTitle = ({ dialog, baseBottomMargin = '0px', baseTopMargin = '12px', onCloseDialog, }) => {
    const screenTitle = useSelector(state => {
        if (dialog.type === 'page' && dialog.screenId) {
            const pageDefinition = getPageDefinition(dialog.screenId, state);
            if (!pageDefinition) {
                return null;
            }
            const locale = state.applicationContext?.locale || 'en-US';
            const { title } = getPageTitlesFromPageDefinition(pageDefinition, locale);
            return title || null;
        }
        return null;
    });
    const isTunnelDialog = useSelector(state => {
        if (dialog.type === 'page' && dialog.screenId) {
            const pageDefinition = getPageDefinition(dialog.screenId, state);
            if (!pageDefinition) {
                return false;
            }
            const breadcrumbs = pageDefinition.queryParameters[QUERY_PARAM_TUNNEL_SEGMENTS];
            if (breadcrumbs && Array.isArray(breadcrumbs)) {
                return true;
            }
        }
        return false;
    });
    const headerLabelField = useSelector(state => {
        if (dialog.type !== 'page' || !dialog.screenId) {
            return null;
        }
        const pageDefinition = getPageDefinition(dialog.screenId, state);
        if (!pageDefinition) {
            return null;
        }
        const pageProperties = getPagePropertiesFromPageDefinition(pageDefinition);
        return pageProperties.headerLabel?.apply(getScreenElement(pageDefinition)) || null;
    });
    return (React.createElement(React.Fragment, null,
        isTunnelDialog && React.createElement(DialogBreadcrumbs, { screenId: dialog.screenId }),
        React.createElement("div", { "data-component": "heading" },
            React.createElement("div", { "data-element": "header-container" },
                React.createElement(Typography, { "data-element": "title", variant: "h1", mt: isTunnelDialog ? '18px' : baseTopMargin, mb: baseBottomMargin },
                    isTunnelDialog && (React.createElement("span", { className: "e-dialog-title-back-button-wrapper" },
                        React.createElement(IconButton, { "aria-label": "icon-button", mr: "24px", onClick: onCloseDialog },
                            React.createElement(Icon, { type: "arrow_left" })))),
                    screenTitle || dialog.title || null,
                    isTunnelDialog && headerLabelField && dialog.screenId && (React.createElement("div", { className: "e-header-title-label" },
                        React.createElement(FieldWrapper, { item: { $bind: headerLabelField.id }, screenId: dialog.screenId, contextType: ContextType.pageHeader }))))))));
};
//# sourceMappingURL=dialog-title.js.map